/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.icons.FlatFileViewDirectoryIcon;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.ScaledImageIcon;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import javax.swing.table.TableCellRenderer;

public class FlatFileChooserUI
extends MetalFileChooserUI {
    private final FlatFileView fileView = new FlatFileView();
    private FlatShortcutsPanel shortcutsPanel;

    public static ComponentUI createUI(JComponent c2) {
        return new FlatFileChooserUI((JFileChooser)c2);
    }

    public FlatFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    @Override
    public void installComponents(JFileChooser fc2) {
        FlatShortcutsPanel panel;
        super.installComponents(fc2);
        this.patchUI(fc2);
        if (!UIManager.getBoolean("FileChooser.noPlacesBar") && (panel = this.createShortcutsPanel(fc2)).getComponentCount() > 0) {
            this.shortcutsPanel = panel;
            fc2.add((Component)this.shortcutsPanel, "Before");
            fc2.addPropertyChangeListener(this.shortcutsPanel);
        }
    }

    @Override
    public void uninstallComponents(JFileChooser fc2) {
        super.uninstallComponents(fc2);
        if (this.shortcutsPanel != null) {
            fc2.removePropertyChangeListener(this.shortcutsPanel);
            this.shortcutsPanel = null;
        }
    }

    private void patchUI(JFileChooser fc2) {
        Component topButtonPanel;
        Component topPanel = fc2.getComponent(0);
        if (topPanel instanceof JPanel && ((JPanel)topPanel).getLayout() instanceof BorderLayout && (topButtonPanel = ((JPanel)topPanel).getComponent(0)) instanceof JPanel && ((JPanel)topButtonPanel).getLayout() instanceof BoxLayout) {
            Insets margin = UIManager.getInsets("Button.margin");
            Component[] comps = ((JPanel)topButtonPanel).getComponents();
            for (int i2 = comps.length - 1; i2 >= 0; --i2) {
                Component c2 = comps[i2];
                if (c2 instanceof JButton || c2 instanceof JToggleButton) {
                    AbstractButton b2 = (AbstractButton)c2;
                    b2.putClientProperty("JButton.buttonType", "toolBarButton");
                    b2.setMargin(margin);
                    b2.setFocusable(false);
                    continue;
                }
                if (!(c2 instanceof Box.Filler)) continue;
                ((JPanel)topButtonPanel).remove(i2);
            }
        }
        try {
            int maximumRowCount;
            Component directoryComboBox = ((JPanel)topPanel).getComponent(2);
            if (directoryComboBox instanceof JComboBox && (maximumRowCount = UIManager.getInt("ComboBox.maximumRowCount")) > 0) {
                ((JComboBox)directoryComboBox).setMaximumRowCount(maximumRowCount);
            }
        }
        catch (ArrayIndexOutOfBoundsException directoryComboBox) {
            // empty catch block
        }
        LayoutManager layout = fc2.getLayout();
        if (layout instanceof BorderLayout) {
            BorderLayout borderLayout = (BorderLayout)layout;
            borderLayout.setHgap(8);
            Component north = borderLayout.getLayoutComponent("North");
            Component lineEnd = borderLayout.getLayoutComponent("After");
            Component center = borderLayout.getLayoutComponent("Center");
            Component south = borderLayout.getLayoutComponent("South");
            if (north != null && lineEnd != null && center != null && south != null) {
                JPanel p2 = new JPanel(new BorderLayout(0, 11));
                p2.add(north, "North");
                p2.add(lineEnd, "After");
                p2.add(center, "Center");
                p2.add(south, "South");
                fc2.add((Component)p2, "Center");
            }
        }
    }

    @Override
    protected JPanel createDetailsView(JFileChooser fc2) {
        JPanel p2 = super.createDetailsView(fc2);
        if (!SystemInfo.isWindows) {
            return p2;
        }
        JScrollPane scrollPane = null;
        for (Component c2 : p2.getComponents()) {
            if (!(c2 instanceof JScrollPane)) continue;
            scrollPane = (JScrollPane)c2;
            break;
        }
        if (scrollPane == null) {
            return p2;
        }
        Component view = scrollPane.getViewport().getView();
        if (!(view instanceof JTable)) {
            return p2;
        }
        JTable table = (JTable)view;
        final TableCellRenderer defaultRenderer = table.getDefaultRenderer(Object.class);
        table.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof String && ((String)value).startsWith("\u200e")) {
                    String str = (String)value;
                    char[] buf = new char[str.length()];
                    int j2 = 0;
                    for (int i2 = 0; i2 < buf.length; ++i2) {
                        char ch2 = str.charAt(i2);
                        if (ch2 == '\u200e' || ch2 == '\u200f') continue;
                        buf[j2++] = ch2;
                    }
                    value = new String(buf, 0, j2);
                }
                return defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        return p2;
    }

    protected FlatShortcutsPanel createShortcutsPanel(JFileChooser fc2) {
        return new FlatShortcutsPanel(fc2);
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Dimension prefSize = super.getPreferredSize(c2);
        Dimension minSize = this.getMinimumSize(c2);
        int shortcutsPanelWidth = this.shortcutsPanel != null ? this.shortcutsPanel.getPreferredSize().width : 0;
        return new Dimension(Math.max(prefSize.width, minSize.width + shortcutsPanelWidth), Math.max(prefSize.height, minSize.height));
    }

    @Override
    public Dimension getMinimumSize(JComponent c2) {
        return UIScale.scale(super.getMinimumSize(c2));
    }

    @Override
    public FileView getFileView(JFileChooser fc2) {
        return FlatFileChooserUI.doNotUseSystemIcons() ? super.getFileView(fc2) : this.fileView;
    }

    @Override
    public void clearIconCache() {
        if (FlatFileChooserUI.doNotUseSystemIcons()) {
            super.clearIconCache();
        } else {
            this.fileView.clearIconCache();
        }
    }

    private static boolean doNotUseSystemIcons() {
        return SystemInfo.isWindows && SystemInfo.isX86 && SystemInfo.isJava_17_orLater && SystemInfo.javaVersion < SystemInfo.toVersion(17, 0, 3, 0);
    }

    private static class ShortcutIcon
    implements Icon {
        private final Icon icon;
        private final int iconWidth;
        private final int iconHeight;

        ShortcutIcon(Icon icon, int iconWidth, int iconHeight) {
            this.icon = icon;
            this.iconWidth = iconWidth;
            this.iconHeight = iconHeight;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            Graphics2D g22 = (Graphics2D)g2.create();
            try {
                g22.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                double scale = (double)this.getIconWidth() / (double)this.icon.getIconWidth();
                g22.translate(x2, y2);
                g22.scale(scale, scale);
                this.icon.paintIcon(c2, g22, 0, 0);
            }
            finally {
                g22.dispose();
            }
        }

        @Override
        public int getIconWidth() {
            return UIScale.scale(this.iconWidth);
        }

        @Override
        public int getIconHeight() {
            return UIScale.scale(this.iconHeight);
        }
    }

    public static class FlatShortcutsPanel
    extends JToolBar
    implements PropertyChangeListener {
        private final JFileChooser fc;
        private final Dimension buttonSize;
        private final Dimension iconSize;
        private final Function<File[], File[]> filesFunction;
        private final Function<File, String> displayNameFunction;
        private final Function<File, Icon> iconFunction;
        protected final File[] files;
        protected final JToggleButton[] buttons;
        protected final ButtonGroup buttonGroup = new ButtonGroup();

        public FlatShortcutsPanel(JFileChooser fc2) {
            super(1);
            this.fc = fc2;
            this.setFloatable(false);
            this.buttonSize = UIScale.scale(this.getUIDimension("FileChooser.shortcuts.buttonSize", 84, 64));
            this.iconSize = this.getUIDimension("FileChooser.shortcuts.iconSize", 32, 32);
            this.filesFunction = (Function)UIManager.get("FileChooser.shortcuts.filesFunction");
            this.displayNameFunction = (Function)UIManager.get("FileChooser.shortcuts.displayNameFunction");
            this.iconFunction = (Function)UIManager.get("FileChooser.shortcuts.iconFunction");
            FileSystemView fsv = fc2.getFileSystemView();
            File[] files = this.getChooserShortcutPanelFiles(fsv);
            if (this.filesFunction != null) {
                files = this.filesFunction.apply(files);
            }
            ArrayList<File> filesList = new ArrayList<File>();
            ArrayList<JToggleButton> buttonsList = new ArrayList<JToggleButton>();
            for (File file : files) {
                if (file == null) continue;
                if (fsv.isFileSystemRoot(file)) {
                    file = fsv.createFileObject(file.getAbsolutePath());
                }
                String name = this.getDisplayName(fsv, file);
                Icon icon = this.getIcon(fsv, file);
                if (name == null) continue;
                int lastSepIndex = name.lastIndexOf(File.separatorChar);
                if (lastSepIndex >= 0 && lastSepIndex < name.length() - 1) {
                    name = name.substring(lastSepIndex + 1);
                }
                if (icon instanceof ImageIcon) {
                    icon = new ScaledImageIcon((ImageIcon)icon, this.iconSize.width, this.iconSize.height);
                } else if (icon != null) {
                    icon = new ShortcutIcon(icon, this.iconSize.width, this.iconSize.height);
                }
                JToggleButton button = this.createButton(name, icon);
                File f2 = file;
                button.addActionListener(e2 -> fc2.setCurrentDirectory(f2));
                this.add(button);
                this.buttonGroup.add(button);
                filesList.add(file);
                buttonsList.add(button);
            }
            this.files = filesList.toArray(new File[filesList.size()]);
            this.buttons = buttonsList.toArray(new JToggleButton[buttonsList.size()]);
            this.directoryChanged(fc2.getCurrentDirectory());
        }

        private Dimension getUIDimension(String key, int defaultWidth, int defaultHeight) {
            Dimension size = UIManager.getDimension(key);
            if (size == null) {
                size = new Dimension(defaultWidth, defaultHeight);
            }
            return size;
        }

        protected JToggleButton createButton(String name, Icon icon) {
            JToggleButton button = new JToggleButton(name, icon);
            button.setVerticalTextPosition(3);
            button.setHorizontalTextPosition(0);
            button.setAlignmentX(0.5f);
            button.setIconTextGap(0);
            button.setPreferredSize(this.buttonSize);
            button.setMaximumSize(this.buttonSize);
            return button;
        }

        protected File[] getChooserShortcutPanelFiles(FileSystemView fsv) {
            try {
                if (SystemInfo.isJava_12_orLater) {
                    Method m2 = fsv.getClass().getMethod("getChooserShortcutPanelFiles", new Class[0]);
                    File[] files = (File[])m2.invoke((Object)fsv, new Object[0]);
                    if (files.length == 1 && files[0].equals(new File(System.getProperty("user.home")))) {
                        files = new File[]{};
                    }
                    return files;
                }
                if (SystemInfo.isWindows) {
                    Class<?> cls = Class.forName("sun.awt.shell.ShellFolder");
                    Method m3 = cls.getMethod("get", String.class);
                    return (File[])m3.invoke(null, "fileChooserShortcutPanelFolders");
                }
            }
            catch (IllegalAccessException cls) {
            }
            catch (Exception ex2) {
                LoggingFacade.INSTANCE.logSevere(null, ex2);
            }
            return new File[0];
        }

        protected String getDisplayName(FileSystemView fsv, File file) {
            String name;
            if (this.displayNameFunction != null && (name = this.displayNameFunction.apply(file)) != null) {
                return name;
            }
            return fsv.getSystemDisplayName(file);
        }

        protected Icon getIcon(FileSystemView fsv, File file) {
            block7: {
                Icon icon;
                if (this.iconFunction != null && (icon = this.iconFunction.apply(file)) != null) {
                    return icon;
                }
                if (FlatFileChooserUI.doNotUseSystemIcons()) {
                    return new FlatFileViewDirectoryIcon();
                }
                try {
                    Class<?> cls;
                    if (SystemInfo.isJava_17_orLater) {
                        Method m2 = fsv.getClass().getMethod("getSystemIcon", File.class, Integer.TYPE, Integer.TYPE);
                        return (Icon)m2.invoke((Object)fsv, file, this.iconSize.width, this.iconSize.height);
                    }
                    if ((this.iconSize.width > 16 || this.iconSize.height > 16) && (cls = Class.forName("sun.awt.shell.ShellFolder")).isInstance(file)) {
                        Method m3 = file.getClass().getMethod("getIcon", Boolean.TYPE);
                        m3.setAccessible(true);
                        Image image = (Image)m3.invoke((Object)file, true);
                        if (image != null) {
                            return new ImageIcon(image);
                        }
                    }
                }
                catch (Exception ex2) {
                    if ("java.lang.reflect.InaccessibleObjectException".equals(ex2.getClass().getName())) break block7;
                    LoggingFacade.INSTANCE.logSevere(null, ex2);
                }
            }
            return fsv.getSystemIcon(file);
        }

        protected void directoryChanged(File file) {
            if (file != null) {
                String absolutePath = file.getAbsolutePath();
                for (int i2 = 0; i2 < this.files.length; ++i2) {
                    if (!this.files[i2].equals(file) && !this.files[i2].getAbsolutePath().equals(absolutePath)) continue;
                    this.buttons[i2].setSelected(true);
                    return;
                }
            }
            this.buttonGroup.clearSelection();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            switch (e2.getPropertyName()) {
                case "directoryChanged": {
                    this.directoryChanged(this.fc.getCurrentDirectory());
                }
            }
        }
    }

    private class FlatFileView
    extends BasicFileChooserUI.BasicFileView {
        private FlatFileView() {
            super(FlatFileChooserUI.this);
        }

        @Override
        public Icon getIcon(File f2) {
            Icon icon = this.getCachedIcon(f2);
            if (icon != null) {
                return icon;
            }
            if (f2 != null && (icon = FlatFileChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(f2)) != null) {
                if (icon instanceof ImageIcon) {
                    icon = new ScaledImageIcon((ImageIcon)icon);
                }
                this.cacheIcon(f2, icon);
                return icon;
            }
            icon = super.getIcon(f2);
            if (icon instanceof ImageIcon) {
                icon = new ScaledImageIcon((ImageIcon)icon);
                this.cacheIcon(f2, icon);
            }
            return icon;
        }
    }
}

